// This may look like C code, but it is really -*- C++ -*-
// WARNING: This file is obsolete.  Use ../DLList.h, if you can.
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef _CObDLList_h
#ifdef __GNUG__
#pragma interface
#endif
#define _CObDLList_h 1

#include "Pix.h"
// #include <Pix.h> CGP, 11/12/00
#include "COb.defs.h"

#ifndef _CObDLListNode_h
#define _CObDLListNode_h 1

struct CObDLListNode
{
  CObDLListNode*         bk;
  CObDLListNode*         fd;
  COb                    hd;
                         CObDLListNode();
                         CObDLListNode(const COb  h, 
                                       CObDLListNode* p = 0,
                                       CObDLListNode* n = 0);
                         ~CObDLListNode();
};

inline CObDLListNode::CObDLListNode() {}

inline CObDLListNode::CObDLListNode(const COb  h, CObDLListNode* p,
                                    CObDLListNode* n)
  :bk(p), fd(n), hd(h) {}

inline CObDLListNode::~CObDLListNode() {}

typedef CObDLListNode* CObDLListNodePtr;

#endif

class CObDLList
{
  friend class          CObDLListTrav;

  CObDLListNode*        h;

public:
                        CObDLList();
                        CObDLList(const CObDLList& a);
                        ~CObDLList();

  CObDLList&            operator = (const CObDLList& a);

  int                   empty();
  int                   length();

  void                  clear();

  Pix                   prepend(COb  item);
  Pix                   append(COb  item);
  void                  join(CObDLList&);

  COb&                  front();
  COb                   remove_front();
  void                  del_front();

  COb&                  rear();
  COb                   remove_rear();
  void                  del_rear();

  COb&                  operator () (Pix p);
  Pix                   first();
  Pix                   last();
  void                  next(Pix& p);
  void                  prev(Pix& p);
  int                   owns(Pix p);
  Pix                   ins_after(Pix p, COb  item);
  Pix                   ins_before(Pix p, COb  item);
  void                  del(Pix& p, int dir = 1);
  void                  del_after(Pix& p);

  void                  error(const char* msg);
  int                   OK();
};


inline CObDLList::~CObDLList()
{
  clear();
}

inline CObDLList::CObDLList()
{
  h = 0;
}

inline int CObDLList::empty()
{
  return h == 0;
}


inline void CObDLList::next(Pix& p)
{
  p = (p == 0 || p == h->bk)? 0 : Pix(((CObDLListNode*)p)->fd);
}

inline void CObDLList::prev(Pix& p)
{
  p = (p == 0 || p == h)? 0 : Pix(((CObDLListNode*)p)->bk);
}

inline Pix CObDLList::first()
{
  return Pix(h);
}

inline Pix CObDLList::last()
{
  return (h == 0)? 0 : Pix(h->bk);
}

inline COb& CObDLList::operator () (Pix p)
{
  if (p == 0) error("null Pix");
  return ((CObDLListNode*)p)->hd;
}

inline COb& CObDLList::front()
{
  if (h == 0) error("front: empty list");
  return h->hd;
}

inline COb& CObDLList::rear()
{
  if (h == 0) error("rear: empty list");
  return h->bk->hd;
}

#endif
